//********************************************************************************************
//
// HDR
// 
//	
/////////////////////////////////////////////
// un-TWEAKABLES 
	matrix WorldIT : WorldInverseTranspose ;
	matrix WorldViewProj : WorldViewProjection ;
	matrix World : World ;
// TWEAKABLES 	
	float blurWidth <> = 0.006f;
	float Brightness <> = 2.0f;
	const float weights7[7] = {0.02 ,0.04 , 0.06 , 0.08 , 0.06 , 0.04 , 0.02 };
	const float weights5[5] = {0.04 , 0.06 , 0.08 , 0.06 , 0.04 };
	const float weights3[3] = {0.06 , 0.08 , 0.06 };
//********************************************************************************************
// Textures
	texture colorTexture 
		<
    			string Name = " ";
    			int MIPLEVELS = 1;
    			string format = "A8R8G8B8";
		>;
	sampler2D colorSampler = sampler_state
		{
			Texture = <colorTexture>;
   	   		ADDRESSU = CLAMP;
   			ADDRESSV = CLAMP;
   			ADDRESSW = CLAMP;
   			 MIPFILTER = NONE;
   			 MINFILTER = LINEAR;
   			 MAGFILTER = LINEAR;
		};

//********************************************************************************************
// DATA STRUCTS 
		struct appdata {
    			float4 Position	: POSITION;
    			float4 UV	: TEXCOORD0;
		};
	struct VS_OUTPUT_BLUR
		{
   			float4 pos         : POSITION;
    			float2 offsetuv[8] : TEXCOORD0;
		};
//********************************************************************************************
// vertex shader
VS_OUTPUT_BLUR VS_Blur(appdata IN,uniform int nsamples,uniform float2 direction)
	{
    		VS_OUTPUT_BLUR OUT = (VS_OUTPUT_BLUR)0;
    			float2 texelSize = blurWidth ;
			float2 s = IN.UV - texelSize*(nsamples-1)*0.5*direction;
    		for(int i=0; i<nsamples; i++) {
   		OUT.offsetuv[i] = s + texelSize*i*direction ;
    		}
  	  OUT.pos = mul(IN.Position,WorldViewProj);
   	return OUT;
}
//********************************************************************************************
// pixel shader
	float4 PS_Blur3(VS_OUTPUT_BLUR IN) : COLOR
		{
    			float4 c = 0;
    				for(int i=0; i<3; i++) {
    				c += tex2D(colorSampler, IN.offsetuv[i]) * weights3[i] ;
   			}
 		return c*Brightness;
	} 
	float4 PS_Blur5(VS_OUTPUT_BLUR IN) : COLOR
		{
    			float4 c = 0;
    				for(int i=0; i<5; i++) {
    				c += tex2D(colorSampler, IN.offsetuv[i]) * weights5[i];
   			}
 		return c*Brightness;
	} 
	float4 PS_Blur7(VS_OUTPUT_BLUR IN) : COLOR
		{
    			float4 c = 0;
    				for(int i=0; i<7; i++) {
    				c += tex2D(colorSampler, IN.offsetuv[i]) * weights7[i] ;
   			}
 		return c*Brightness;
	} 
//********************************************************************************************
// technique  weights 3
	technique weights3_cam1
 		{
			pass one
			{
				VertexShader = compile vs_2_0 VS_Blur(3, float2(1,1));
				PixelShader  = compile ps_2_0 PS_Blur3();
				srcBlend = One;
				DestBlend = One;
			}
			pass two
			{
				VertexShader = compile vs_2_0 VS_Blur(3, float2(1,-1));
				PixelShader  = compile ps_2_0 PS_Blur3();
				SrcBlend = One;
				DestBlend = One;
				}
	}
	technique weights3_cam2
 		{
			pass one
			{
				VertexShader = compile vs_2_0 VS_Blur(3, float2(0,1));
				PixelShader  = compile ps_2_0 PS_Blur3();
				srcBlend = One;
				DestBlend = One;
			}
			pass two
			{
				VertexShader = compile vs_2_0 VS_Blur(3, float2(1,0));
				PixelShader  = compile ps_2_0 PS_Blur3();
				SrcBlend = One;
				DestBlend = One;
				}
	}
// technique  weights 5
	technique weights5_cam1
 		{
			pass one
			{
				VertexShader = compile vs_2_0 VS_Blur(5, float2(1,1));
				PixelShader  = compile ps_2_0 PS_Blur5();
				srcBlend = One;
				DestBlend = One;
			}
			pass two
			{
				VertexShader = compile vs_2_0 VS_Blur(5, float2(1,-1));
				PixelShader  = compile ps_2_0 PS_Blur5();
				SrcBlend = One;
				DestBlend = One;
				}
	}
	technique weights5_cam2
 		{
			pass one
			{
				VertexShader = compile vs_2_0 VS_Blur(5, float2(0,1));
				PixelShader  = compile ps_2_0 PS_Blur5();
				srcBlend = One;
				DestBlend = One;
			}
			pass two
			{
				VertexShader = compile vs_2_0 VS_Blur(5, float2(1,0));
				PixelShader  = compile ps_2_0 PS_Blur5();
				SrcBlend = One;
				DestBlend = One;
				}
	}
// technique  weights 7
	technique weights7_cam1
 		{
			pass one
			{
				VertexShader = compile vs_2_0 VS_Blur(7, float2(0,1));
				PixelShader  = compile ps_2_0 PS_Blur7();
				srcBlend = One;
				DestBlend = One;
			}
			pass two
			{
				VertexShader = compile vs_2_0 VS_Blur(7, float2(1,0));
				PixelShader  = compile ps_2_0 PS_Blur7();
				SrcBlend = One;
				DestBlend = One;
				}
	}
	technique weights7_cam2
 		{
			pass one
			{
				VertexShader = compile vs_2_0 VS_Blur(7, float2(1,1));
				PixelShader  = compile ps_2_0 PS_Blur7();
				srcBlend = One;
				DestBlend = One;
			}
			pass two
			{
				VertexShader = compile vs_2_0 VS_Blur(7, float2(1,-1));
				PixelShader  = compile ps_2_0 PS_Blur7();
				SrcBlend = One;
				DestBlend = One;
				}
	}
//********************************************************************************************